---
description: "Learn more about: Combiner functions"
title: "Combiner functions"
ms.date: 10/19/2023
ms.custom: "nonautomated-date"
---
# Combiner functions

These functions are used by other library functions that merge values. For example, [Table.ToList](table-tolist.md) and [Table.CombineColumns](table-combinecolumns.md) apply a combiner function to each row in a table to produce a single value for each row.

|Name|Description|
|------------|---------------|
|[Combiner.CombineTextByDelimiter](combiner-combinetextbydelimiter.md)|Returns a function that combines a list of text using the specified delimiter.|
|[Combiner.CombineTextByEachDelimiter](combiner-combinetextbyeachdelimiter.md)|Returns a function that combines a list of text using a sequence of delimiters.|
|[Combiner.CombineTextByLengths](combiner-combinetextbylengths.md)|Returns a function that combines a list of text using the specified lengths.|
|[Combiner.CombineTextByPositions](combiner-combinetextbypositions.md)|Returns a function that combines a list of text using the specified output positions.|
|[Combiner.CombineTextByRanges](combiner-combinetextbyranges.md)|Returns a function that combines a list of text using the specified positions and lengths.|
